/*
 *   This file is part of Skript.
 *
 *  Skript is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Skript is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Skript.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * 
 * Copyright 2011, 2012 Peter Gttinger
 * 
 */

package ch.njol.skript.loops;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.server.ServerCommandEvent;

import ch.njol.skript.CommandEvent;
import ch.njol.skript.Skript;
import ch.njol.skript.api.LoopVar;
import ch.njol.skript.api.Variable;
import ch.njol.skript.util.Utils;
import ch.njol.util.ObjectIterator;

/**
 * @author Peter Gttinger
 * 
 */
public class LoopVarArguments extends LoopVar<Object> {
	
	static {
		Skript.addLoop(LoopVarArguments.class, Object.class, "argument", "arguments", "arguments as (.+)");
	}
	
	private Class<?> r = null;
	
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) {
		if (matchedPattern != 0) {
			r = Skript.getClassFromUserInput(matcher.group(1));
			if (r == null) {
				Skript.setErrorCause("'" + matcher.group(1) + "' is not a known type", true);
			}
		}
	}
	
	@Override
	protected Iterator<Object> iterator(final Event e) {
		String s;
		if (e instanceof PlayerCommandPreprocessEvent) {
			s = ((PlayerCommandPreprocessEvent) e).getMessage();
		} else if (e instanceof ServerCommandEvent) {
			s = ((ServerCommandEvent) e).getCommand();
		} else if (e instanceof CommandEvent) {
			s = Utils.join(((CommandEvent) e).getArgs(), " ");
		} else {
			return null;
		}
		if (r == null) {
			return new ObjectIterator(Arrays.asList(s.split(" ")).iterator());
		}
		return new ObjectIterator(Arrays.asList(Expressions.parseData(s, r)).iterator());
	}
	
	@Override
	public Class<? extends Object> getReturnType() {
		return Object.class;
	}
	
	@Override
	public String getDebugMessage(final Event e) {
		return "arguments" + (r == null ? "" : " as " + r.getName());
	}
	
}
