/*
 *   This file is part of Skript.
 *
 *  Skript is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Skript is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Skript.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * 
 * Copyright 2011, 2012 Peter Gttinger
 * 
 */

package ch.njol.skript.effects;

import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Effect;
import ch.njol.skript.api.Variable;
import ch.njol.skript.util.Slot;

/**
 * 
 * @author Peter Gttinger
 * 
 */
public class EffHealth extends Effect {
	
	/* TODO: method to find out whether a variable is a default variable?
	 * or option to set to not add default variables to the vars list?
	 * or specifiy 2 regexes ea?
	 * 
	 * current:
	 * heal player => heal player by 1
	 * repair tool => repair tool by 1
	 * 
	 * future:
	 * heal player => heal player by 20
	 * repair tool by max (i.e. set durability to 0) */
	
	static {
		Skript.addEffect(EffHealth.class,
				"damage %object% by %integer%",
				"heal %livingentity%( by %integer%)?",
				"repair %slot%( by %integer%)?");
	}
	
	private Variable<Object> damageables;
	private Variable<Integer> damages;
	private boolean heal = false;
	
	@SuppressWarnings("unchecked")
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) {
		damageables = (Variable<Object>) vars.get(0);
		damages = (Variable<Integer>) vars.get(1);
		heal = (matchedPattern != 0);
	}
	
	@Override
	public void execute(final Event e) {
		for (final Object damageable : damageables.get(e, false)) {
			for (final Integer damage : damages.get(e, false)) {
				if (damageable instanceof Slot) {
					final ItemStack is = ((Slot) damageable).getItem();
					is.setDurability((short) (is.getDurability() + (heal ? -damage.shortValue() : damage.shortValue())));
					((Slot) damageable).setItem(is);
				} else if (damageable instanceof LivingEntity) {
					((LivingEntity) damageable).damage(heal ? -damage : damage);
				}
			}
		}
	}
	
	@Override
	public String getDebugMessage(final Event e) {
		return (heal ? "heal " : "damage ") + damageables.getDebugMessage(e) + " by " + damages.getDebugMessage(e);
	}
	
}
