/*
 *   This file is part of Skript.
 *
 *  Skript is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Skript is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Skript.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * 
 * Copyright 2011, 2012 Peter Gttinger
 * 
 */

package ch.njol.skript.effects;

import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.CropState;
import org.bukkit.Material;
import org.bukkit.TreeSpecies;
import org.bukkit.TreeType;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.event.Event;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Effect;
import ch.njol.skript.api.Variable;

/**
 * TODO isn't there an easier way?
 * 
 * @author Peter Gttinger
 * 
 */
public class EffFertilize extends Effect {
	
	// static {
	// Skript.addEffect(EffFertilize.class, "fertili[zs]e( %block%)?");
	// }
	
	Variable<Block> blocks;
	
	@SuppressWarnings("unchecked")
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) {
		blocks = (Variable<Block>) vars.get(0);
	}
	
	@Override
	public void execute(final Event e) {
		for (final Block b : blocks.get(e, false)) {
			switch (b.getType()) {
				case SAPLING:
					TreeType treeType = TreeType.TREE;
					switch (TreeSpecies.getByData(b.getData())) {
						case GENERIC:
							if (Skript.random.nextFloat() < (b.getBiome() == Biome.RAINFOREST ? 0.3 : 0.1))
								treeType = TreeType.BIG_TREE;
							else
								treeType = TreeType.TREE;
						break;
						case REDWOOD:
							if (Skript.random.nextFloat() < 0.5)
								treeType = TreeType.TALL_REDWOOD;
							else
								treeType = TreeType.REDWOOD;
						break;
						case BIRCH:
							treeType = TreeType.BIRCH;
						break;
					}
					b.getWorld().generateTree(b.getLocation(), treeType);
				break;
				case RED_MUSHROOM:
				break;
				case BROWN_MUSHROOM:
				break;
				case CROPS:
					b.setData(CropState.RIPE.getData());
				break;
				case MELON_STEM:
				case PUMPKIN_STEM:
					boolean done = false;
					for (int x = -1; x <= 1; x += 2) {
						for (int z = -1; z <= 1; z += 2) {
							if (b.getRelative(x, 0, z).getType() == Material.AIR && b.getRelative(x, -1, z).getType() == Material.SOIL) {
								b.getRelative(x, 0, z).setType(b.getType() == Material.MELON_STEM ? Material.MELON_BLOCK : Material.PUMPKIN);
								b.setData((byte) 0x7);
								done = true;
								break;
							}
						}
						if (done)
							break;
					}
				break;
				default:
					continue;
			}
		}
	}
	
	@Override
	public String getDebugMessage(final Event e) {
		return "fertilize " + blocks.getDebugMessage(e);
	}
	
}
