/*
 *   This file is part of Skript.
 *
 *  Skript is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Skript is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Skript.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * 
 * Copyright 2011, 2012 Peter Gttinger
 * 
 */

package ch.njol.skript.effects;

import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.event.Event;

import ch.njol.skript.Skript;
import ch.njol.skript.Trigger;
import ch.njol.skript.TriggerFileLoader;
import ch.njol.skript.api.Effect;
import ch.njol.skript.api.Variable;
import ch.njol.skript.api.intern.Loop;
import ch.njol.skript.api.intern.TriggerItem;

/**
 * @author Peter Gttinger
 * 
 */
public class EffExit extends Effect {
	
	static {
		Skript.addEffect(EffExit.class, "(exit|stop)( trigger)?", "(exit|stop) (1 )?section", "(exit|stop) (\\d+) sections", "(exit|stop) all sections");
	}
	
	private int breakLevels;
	
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) {
		switch (matchedPattern) {
			case 0:
				breakLevels = TriggerFileLoader.currentSections.size() + 1;
			break;
			case 1:
				breakLevels = 1;
			break;
			case 2:
				breakLevels = Integer.parseInt(matcher.group(2));
				if (breakLevels > TriggerFileLoader.currentSections.size()) {
					if (TriggerFileLoader.currentSections.isEmpty())
						Skript.error("You can't " + matcher.group(1) + " any sections because there are no sections present");
					else
						Skript.error("You can't " + matcher.group() + " because there are only " + TriggerFileLoader.currentSections.size() + " sections present");
					breakLevels = TriggerFileLoader.currentSections.size();
					return;
				}
			break;
			case 3:
				breakLevels = TriggerFileLoader.currentSections.size();
			break;
		}
	}
	
	@Override
	protected void execute(final Event e) {
		int i = breakLevels;
		TriggerItem item = this;
		while (i > 0) {
			item = item.getParent();
			if (item instanceof Loop) {
				((Loop) item).stop();
			} else if (item instanceof Trigger) {
				((Trigger) item).stop();
			} else {
				throw new RuntimeException("parent of invalid type");
			}
			i--;
		}
	}
	
	@Override
	public String getDebugMessage(final Event e) {
		return "exit " + breakLevels + " levels";
	}
	
}
