/*
 *   This file is part of Skript.
 *
 *  Skript is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Skript is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Skript.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * 
 * Copyright 2011, 2012 Peter Gttinger
 * 
 */

package ch.njol.skript.data;

import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Comparator;
import ch.njol.skript.util.EntityType;
import ch.njol.skript.util.ItemType;
import ch.njol.skript.util.Time;
import ch.njol.skript.util.Timeperiod;

/**
 * @author Peter Gttinger
 * 
 */
public class DefaultComparators {
	
	public DefaultComparators() {}
	
	static {
		
		// IMPORTANT!! NO Object - Object comparator
		
		// ItemStack - ItemType
		Skript.addComparator(ItemStack.class, ItemType.class, new Comparator<ItemStack, ItemType>() {
			@Override
			public Relation compare(final ItemStack is, final ItemType it) {
				return Relation.get(it.isOfType(is));
			}
		});
		
		// Block - ItemType
		Skript.addComparator(Block.class, ItemType.class, new Comparator<Block, ItemType>() {
			@Override
			public Relation compare(final Block b, final ItemType it) {
				return Relation.get(it.isOfType(b));
			}
		});
		
		// Number - Number
		Skript.addComparator(Number.class, Number.class, new Comparator<Number, Number>() {
			@Override
			public Relation compare(final Number n1, final Number n2) {
				return Relation.get(n1.doubleValue() - n2.doubleValue());
			}
		});
		
		// Entity - EntityType
		Skript.addComparator(Entity.class, EntityType.class, new Comparator<Entity, EntityType>() {
			@Override
			public ch.njol.skript.api.Comparator.Relation compare(final Entity e, final EntityType t) {
				return Relation.get(t.isInstance(e));
			}
		});
		
		// Time - Timeperiod
		Skript.addComparator(Time.class, Timeperiod.class, new Comparator<Time, Timeperiod>() {
			@Override
			public ch.njol.skript.api.Comparator.Relation compare(final Time t, final Timeperiod p) {
				return Relation.get(p.contains(t));
			}
		});
		
	}
	
}
