/*
 *   This file is part of Skript.
 *
 *  Skript is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Skript is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Skript.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * 
 * Copyright 2011, 2012 Peter Gttinger
 * 
 */

package ch.njol.skript.config;

import java.io.PrintWriter;

import ch.njol.skript.SkriptLogger;

/**
 * 
 * an empty line, usually a comment.<br/>
 * the subclass {@link InvalidNode} is for invalid non-empty nodes, i.e. where a parsing error ocurred.
 * 
 * @author unicode21B9
 * 
 */
public class VoidNode extends ConfigNode {
	
	VoidNode(final SectionNode parent, final String line, final int lineNum) {
		super(parent.getConfig(), line, line, lineNum);
		name = orig = line;
		this.parent = parent;
		SkriptLogger.setNode(this);
	}
	
	VoidNode(final SectionNode parent) {
		super(parent.getConfig(), parent.getConfig().r.getLine(), parent.getConfig().r.getLine(), parent.getConfig().r.getLineNum());
		this.parent = parent;
		SkriptLogger.setNode(this);
	}
	
	@Override
	public boolean setValue(final String v) {
		orig = v;
		return true;
	}
	
	@Override
	void save(final PrintWriter w) {
		w.println(orig);
	}
}
