/*
 *   This file is part of Skript.
 *
 *  Skript is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Skript is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Skript.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * 
 * Copyright 2011, 2012 Peter Gttinger
 * 
 */

package ch.njol.skript.config;

import java.io.PrintWriter;

public class ParseOptionNode extends ConfigNode {
	
	ParseOptionNode(final String name, final SectionNode parent) {
		super(name, parent);
	}
	
	@Override
	void save(final PrintWriter w) {
		final String option = orig.substring(getOrig().indexOf('[') + 1, orig.indexOf(']'));
		w.println(getIndentation() + orig.trim());
		if (orig.startsWith("!indentation[")) {
			setIndentation(option);
		} else if (orig.startsWith("!separator[")) {
			config.separator = option;
		}
		modified = false;
	}
	
}
