/*
 *   This file is part of Skript.
 *
 *  Skript is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Skript is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Skript.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * 
 * Copyright 2011, 2012 Peter Gttinger
 * 
 */

package ch.njol.skript.config;

import java.util.Iterator;
import java.util.ListIterator;

import ch.njol.skript.SkriptLogger;

public class ConfigNodeIterator implements Iterator<ConfigNode> {
	
	private final ConfigNode parent;
	private final ListIterator<ConfigNode> iter;
	private final boolean includeVoid;
	
	public ConfigNodeIterator(final SectionNode parent, final boolean includeVoid) {
		this.parent = parent;
		iter = parent.getNodeList().listIterator();
		this.includeVoid = includeVoid;
	}
	
	@Override
	public boolean hasNext() {
		if (includeVoid) {
			if (!iter.hasNext()) {
				SkriptLogger.setNode(parent.getParent() != null ? parent : null);
				return false;
			}
			return true;
		}
		while (iter.hasNext()) {
			if (!next().isVoid()) {
				iter.previous();
				return true;
			}
		}
		SkriptLogger.setNode(parent.getParent() != null ? parent : null);
		return false;
	}
	
	@Override
	public ConfigNode next() {
		ConfigNode n;
		if (!includeVoid) {
			do {
				n = iter.next();
			} while (n.isVoid());
		} else {
			n = iter.next();
		}
		SkriptLogger.setNode(n);
		return n;
	}
	
	@Override
	public void remove() {
		throw new UnsupportedOperationException();
	}
	
}
