/*
 *   This file is part of Skript.
 *
 *  Skript is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Skript is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Skript.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * 
 * Copyright 2011, 2012 Peter Gttinger
 * 
 */

package ch.njol.skript.api.intern;

import java.util.List;

import org.bukkit.event.Event;

import ch.njol.skript.Skript;
import ch.njol.skript.Trigger;
import ch.njol.skript.TriggerFileLoader;
import ch.njol.skript.config.SectionNode;

/**
 * @author Peter Gttinger
 * 
 */
public abstract class TriggerSection extends TriggerItem {
	
	private final List<TriggerItem> items;
	
	private boolean stopped = false;
	
	private static String indentation = "  ";
	
	/**
	 * reserved for new Trigger(...)
	 */
	protected TriggerSection(final List<TriggerItem> items) {
		this.items = items;
	}
	
	protected TriggerSection(final SectionNode node) {
		TriggerFileLoader.currentSections.add(this);
		items = TriggerFileLoader.loadItems(node);
		TriggerFileLoader.currentSections.remove(TriggerFileLoader.currentSections.size() - 1);
	}
	
	protected void run(final Event e, final boolean run) {
		if (Skript.logVeryHigh() && !(this instanceof Trigger))
			Skript.info(indentation + (run ? "" : "-") + getDebugMessage(e) + ":");
		if (!run)
			return;
		stopped = false;
		if (Skript.logVeryHigh() && !(this instanceof Trigger))
			indentation += "  ";
		for (final TriggerItem i : items) {
			final boolean ok = i.run(e);
			if (Skript.logVeryHigh() && !(i instanceof TriggerSection)) {
				if (!stopped)
					Skript.info(indentation + (ok ? "" : "-") + i.getDebugMessage(e));
				else
					Skript.info(indentation + "#" + i.getDebugMessage(e));
			}
			if (!ok)
				break;
			if (stopped) {
				stopped = false;
				break;
			}
		}
		if (Skript.logVeryHigh() && !(this instanceof Trigger))
			indentation = indentation.substring(indentation.length() - 2);
	}
	
	public void stop() {
		stopped = true;
	}
	
}
