/*
 *   This file is part of Skript.
 *
 *  Skript is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Skript is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Skript.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * 
 * Copyright 2011, 2012 Peter Gttinger
 * 
 */

package ch.njol.skript.api.intern;

import java.lang.reflect.Array;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Converter;

/**
 * @author Peter Gttinger
 * 
 */
public class ParsedLiteral extends Literal<String> {
	
	/**
	 * 
	 * @param data trim()med Strings
	 * @param and
	 */
	public ParsedLiteral(final String[] data, final boolean and) {
		super(data, String.class, and);
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public <R> Literal<? extends R> getConvertedVar(final Class<R> to) {
		// strings have to be enclosed in quotes!
//		if (String.class.isAssignableFrom(to))
//			return (Literal<R>) this;
		if (to == Object.class)
			throw new SkriptAPIException("can't parse as Object");
		final Converter<String, ? extends R> p = Skript.getParser(to);
		if (p == null)
			return null;
		final R[] parsedData = (R[]) Array.newInstance(to, data.length);
		for (int i = 0; i < data.length; i++) {
			if ((parsedData[i] = p.convert(data[i])) == null) {
				Skript.setErrorCause("'" + data[i] + "' is not a(n) " + to.getSimpleName(), false);
				return null;
			}
		}
		return new Literal<R>(parsedData, to, and);
	}
	
}
