/*
 *   This file is part of Skript.
 *
 *  Skript is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Skript is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Skript.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * 
 * Copyright 2011, 2012 Peter Gttinger
 * 
 */

package ch.njol.skript.api.intern;

import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.event.Event;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Changer.ChangeMode;
import ch.njol.skript.api.Converter;
import ch.njol.skript.api.Variable;

/**
 * @author Peter Gttinger
 * 
 */
public class ConvertedVariable<F, T> extends Variable<T> {
	
	private final Variable<? extends F> var;
	private final Converter<? super F, ? extends T> converter;
	private final Class<T> to;
	
	private ConvertedVariable(final Variable<? extends F> var, final Converter<? super F, ? extends T> converter, final Class<T> to) {
		this.var = var;
		this.converter = converter;
		this.to = to;
	}
	
	@SuppressWarnings("unchecked")
	public static <F, T> Variable<T> newInstance(final Variable<F> v, final Class<T> to) {
		if (v == null)
			return null;
		if (to.isAssignableFrom(v.getReturnType()))
			return (Variable<T>) v;
		if (v instanceof ConvertedVariable)
			return newInstance(((ConvertedVariable<?, ?>) v).var, to);
		return newInstance(v, v.getReturnType(), to);
	}
	
	@SuppressWarnings("unchecked")
	private static <F, T> ConvertedVariable<F, T> newInstance(final Variable<F> v, final Class<? extends F> from, final Class<T> to) {
		final Converter<? super F, ? extends T> c = (Converter<? super F, ? extends T>) Skript.getConverter(from, to);
		if (c == null)
			return null;
		return new ConvertedVariable<F, T>(v, c, to);
	}
	
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) {}
	
	@Override
	protected T[] getAll(final Event e) {
		return get(e, var, converter, true);
	}
	
	@Override
	public void setAnd(final boolean and) {
		super.setAnd(and);
		var.setAnd(and);
	}
	
	@Override
	public Class<T> getReturnType() {
		return to;
	}
	
	@Override
	public String getDebugMessage(final Event e) {
		if (e == null)
			return "{" + var.getDebugMessage(null) + "}->" + to.getName();
		return var.getDebugMessage(e);
	}
	
	@Override
	public Class<?> acceptChange(final ChangeMode mode) {
		return var.acceptChange(mode);
	}
	
	@Override
	public void change(final Event e, final Variable<?> delta, final ChangeMode mode) {
		var.change(e, delta, mode);
	}
	
	@Override
	public String toString() {
		return var.toString();
	}
	
}
