/*
 *   This file is part of Skript.
 *
 *  Skript is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Skript is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Skript.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * 
 * Copyright 2011, 2012 Peter Gttinger
 * 
 */

package ch.njol.skript.api;

/**
 * Used to get a specific value from instances of the same type. The kind of value depends on where and how this getter is used.
 * 
 * @author Peter Gttinger
 * 
 * @param <R> the returned value type
 * @param <A> the type which holds the value. Tipp: You can use <code>Void</code>
 */
public abstract class Getter<R, A> implements Converter<A, R> {
	
	/**
	 * Gets a value from the given object.
	 * 
	 * @param arg the object to get the value from
	 * @return the value
	 */
	public abstract R get(A arg);
	
	@Override
	public R convert(final A a) {
		return get(a);
	}
	
}
