/*
 *   This file is part of Skript.
 *
 *  Skript is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Skript is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Skript.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * 
 * Copyright 2011, 2012 Peter Gttinger
 * 
 */

package ch.njol.skript.api;

/**
 * Used to compare two objects of a different or the same type.
 * 
 * @author Peter Gttinger
 * 
 * @param <T1> ,
 * @param <T2> the types to compare
 */
public interface Comparator<T1, T2> {
	
	/**
	 * represents a relation between two objects.
	 */
	public static enum Relation {
		EQUAL, GREATER, SMALLER, NOT_EQUAL;
		
		public static Relation get(final boolean b) {
			return b ? Relation.EQUAL : Relation.NOT_EQUAL;
		}
		
		public static Relation get(final int i) {
			return i == 0 ? Relation.EQUAL : i > 0 ? Relation.GREATER : Relation.SMALLER;
		}
		
		public static Relation get(final double d) {
			return d == 0 ? Relation.EQUAL : d > 0 ? Relation.GREATER : Relation.SMALLER;
		}
		
		public boolean is(final Relation other) {
			switch (this) {
				case EQUAL:
					return other == EQUAL;
				case GREATER:
					return other == GREATER;
				case NOT_EQUAL:
					return other != EQUAL;
				case SMALLER:
					return other == SMALLER;
			}
			return false;
		}
		
		@Override
		public String toString() {
			switch (this) {
				case EQUAL:
					return "equal to";
				case GREATER:
					return "greather than";
				case NOT_EQUAL:
					return "not equal to";
				case SMALLER:
					return "smaller than";
			}
			throw new RuntimeException();
		}
	}
	
	/**
	 * holds information a about a comparator.
	 * 
	 * @author Peter Gttinger
	 * 
	 * @param <T1>
	 * @param <T2>
	 */
	public static class ComparatorInfo<T1, T2> {
		
		public Class<T1> c1;
		public Class<T2> c2;
		public Comparator<T1, T2> c;
		
		public ComparatorInfo(final Class<T1> c1, final Class<T2> c2, final Comparator<T1, T2> c) {
			this.c1 = c1;
			this.c2 = c2;
			this.c = c;
		}
		
		public Class<?> getType(final int i) {
			return i == 0 ? c1 : c2;
		}
		
	}
	
	Comparator<?, ?> equalsComparator = new Comparator<Object, Object>() {
		@Override
		public ch.njol.skript.api.Comparator.Relation compare(final Object o1, final Object o2) {
			if (o1 == null || o2 == null)
				return Relation.get(o1 == o2);
			return Relation.get(o1.equals(o2));
		}
	};
	
	/**
	 * compares the given objects.
	 * 
	 * @param o1
	 * @param o2
	 * @return the relation of the obects. GREATER/SMALLER means the first parameter is greater/smaller. NOT_EQUAL is used for values which can't be compared by value.
	 */
	public Relation compare(T1 o1, T2 o2);
	
}
