/*
 *   This file is part of Skript.
 *
 *  Skript is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Skript is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Skript.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * 
 * Copyright 2011, 2012 Peter Gttinger
 * 
 */

package ch.njol.skript;

import java.util.List;

import org.bukkit.event.Event;

import ch.njol.skript.api.SkriptEvent;
import ch.njol.skript.api.intern.TriggerItem;
import ch.njol.skript.api.intern.TriggerSection;

/**
 * 
 * @author Peter Gttinger
 * 
 */
public class Trigger extends TriggerSection {
	public final String name;
	SkriptEvent event;
	
	public Trigger(final String name, final SkriptEvent event, final List<TriggerItem> items) {
		super(items);
		this.name = name;
		this.event = event;
	}
	
	@Override
	public boolean run(final Event e) {
		if (Skript.log(Verbosity.VERY_HIGH))
			Skript.info("# " + name);
		super.run(e, event.check(e));
		return true;
	}
	
	@Override
	public String getDebugMessage(final Event e) {
		throw new RuntimeException("a trigger's debug message should not be used");
	}
	
}
