/*
 *   This file is part of Skript.
 *
 *  Skript is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Skript is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Skript.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * 
 * Copyright 2011, 2012 Peter Gttinger
 * 
 */

package ch.njol.skript;

import java.util.logging.Level;

import org.bukkit.Bukkit;

import ch.njol.skript.config.ConfigNode;

public abstract class SkriptLogger {
	
	private static ConfigNode node = null;
	
	static Verbosity verbosity = Verbosity.NORMAL;
	
	/**
	 * TODO copy this to all aliases <br/>
	 * <br/>
	 * usage:
	 * 
	 * <pre>
	 * if (Skript.log(someverbosity))
	 * 	Skript.log(somelevel, somestring);
	 * </pre>
	 * 
	 * the same applies to all aliases of this method (info, error, etc.)
	 * 
	 * @param msg
	 */
	static void log(final Level level, final String message) {
		if (node != null && (level == Level.SEVERE || level == Level.WARNING)) {
			if (node.getParent() != null)
				Bukkit.getLogger().log(level, "[Skript] " + message +
						" (" + node.getConfig().getFileName() + ", line " + node.getLine() + ": '" + node.getOrig().trim() + "')");
			else
				Bukkit.getLogger().log(level, "[Skript] " + message +
						" (" + node.getConfig().getFileName() + " [unknown line])");
		} else {
			Bukkit.getLogger().log(level, "[Skript] " + message);
		}
	}
	
	public static void expectationError(final String expectedType, final String found) {
		log(Level.SEVERE, "expecting " + expectedType + ", found: '" + found + "'");
	}
	
	public static void setNode(final ConfigNode node) {
		SkriptLogger.node = node;
	}
	
	/**
	 * checks whether messages should be logged for the given verbosity.
	 * 
	 * @param minVerb minimal verbosity
	 * @return
	 */
	public static boolean log(final Verbosity minVerb) {
		return minVerb.compareTo(verbosity) <= 0;
	}
	
}
