/*
 *   This file is part of Skript.
 *
 *  Skript is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Skript is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Skript.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * 
 * Copyright 2011, 2012 Peter Gttinger
 * 
 */

package ch.njol.skript;

import java.util.ArrayList;
import java.util.List;

import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

import ch.njol.skript.api.SimpleEvent;
import ch.njol.skript.api.intern.TriggerItem;

/**
 * This class is used for user-defined commands.
 * 
 * @author Peter Gttinger
 * 
 */
public class SkriptCommand extends Command {
	
	private final Trigger trigger;
	
	/**
	 * 
	 * @param name /name
	 * @param description
	 * @param usageMessage message to display if the command was used incorrectly (TODO)
	 * @param aliases /alias1, /alias2
	 * @param permission permission or null if none
	 * @param permissionMessage message to display if the player doesn't have the given permission
	 * @param items trigger to execute
	 */
	public SkriptCommand(final String name, final String description, final String usageMessage, final List<String> aliases, final String permission, final String permissionMessage, final List<TriggerItem> items) {
		super(name, description, usageMessage, aliases == null ? new ArrayList<String>(0) : aliases);
		trigger = new Trigger("command /" + name, new SimpleEvent(), items);
		setPermission(permission);
		setPermissionMessage(permissionMessage == null ? "you don't have the required permission to use this command" : permissionMessage);
	}
	
	@Override
	public boolean execute(final CommandSender sender, final String commandLabel, final String[] args) {
		return trigger.run(new SkriptCommandEvent(this, sender, args));
	}
	
}
