/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.util;

import java.util.Iterator;

/**
 * @author Peter Gttinger
 * 
 */
public class SingleItemIterator<T> implements Iterator<T> {
	
	private final T item;
	private boolean returned = false;
	
	public SingleItemIterator(final T item) {
		this.item = item;
	}
	
	@Override
	public boolean hasNext() {
		return !returned;
	}
	
	@Override
	public T next() {
		returned = true;
		return item;
	}
	
	@Override
	public void remove() {}
	
}
