/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.util;

import java.util.Iterator;

/**
 * @author Peter Gttinger
 * 
 */
public class ObjectIterator implements Iterator<Object> {
	
	private final Iterator<?> iter;
	
	public ObjectIterator(final Iterator<?> iter) {
		this.iter = iter;
	}
	
	@Override
	public boolean hasNext() {
		return iter.hasNext();
	}
	
	@Override
	public Object next() {
		return iter.next();
	}
	
	@Override
	public void remove() {
		iter.remove();
	}
	
}
