/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.util;

import java.util.Iterator;
import java.util.ListIterator;

public class ListRangeIterator<T> implements Iterator<T> {
	
	private final ListIterator<T> iter;
	private final int end;
	
	public ListRangeIterator(final ListIterator<T> iter, final int start, final int end) {
		this.iter = iter;
		for (int i = 0; i < start; i++)
			iter.next();
		this.end = end;
	}
	
	@Override
	public boolean hasNext() {
		return iter.nextIndex() < end;
	}
	
	@Override
	public T next() {
		return iter.next();
	}
	
	@Override
	public void remove() {
		iter.remove();
	}
	
}
