/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.variables.base;

import org.bukkit.event.Event;

import ch.njol.skript.api.Changer.ChangeMode;
import ch.njol.skript.api.Variable;

/**
 * @author Peter Gttinger
 * 
 */
public abstract class VarVariable extends Variable<Object> {
	
	protected Variable<?> var;
	
	@Override
	public <R> Variable<R> getConvertedVar(final Class<R> to) {
		return var.getConvertedVar(to);
	}
	
	@Override
	protected Object[] getAll(final Event e) {
		return var.get(e);
	}
	
	@Override
	public void setAnd(final boolean and) {
		super.setAnd(and);
		var.setAnd(and);
	}
	
	@Override
	public Class<?> getReturnType() {
		return var.getReturnType();
	}
	
	@Override
	public Class<?> acceptChange(final ChangeMode mode) {
		return var.acceptChange(mode);
	}
	
	@Override
	public void change(final Event e, final Object[] delta, final ChangeMode mode) {
		var.change(e, delta, mode);
	}
	
}
