/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.variables.base;

import java.lang.reflect.Array;
import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.event.Event;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Parser;
import ch.njol.skript.api.Variable;

/**
 * An useful class to extend to create a default variable. <br/>
 * see also: {@link Skript#addClass(String, Class, Class, Parser, String...)}
 * 
 * @author Peter Gttinger
 * 
 */
public abstract class SimpleDefaultVariable<T> extends Variable<T> {
	
	private final Class<T> c;
	
	public SimpleDefaultVariable(final Class<T> c) {
		this.c = c;
	}
	
	@Override
	public final void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) {}
	
	@Override
	public final T[] getAll(final Event e) {
		@SuppressWarnings("unchecked")
		final T[] t = (T[]) Array.newInstance(c, 1);
		t[0] = Skript.getEventValue(e, c);
		return t;
	}
	
	@Override
	public Class<T> getReturnType() {
		return c;
	}
	
	@Override
	public String getDebugMessage(final Event e) {
		if (e == null)
			return "SimpleDefaultVariable(class=" + c.getName() + ")";
		return Skript.toString(getAll(e)[0]);
	}
	
}
