/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.variables.base;

import java.lang.reflect.Array;
import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.event.Event;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Variable;

/**
 * An invariable variable which returns the event value of the given class.
 * 
 * @author Peter Gttinger
 * 
 */
public abstract class EventValueVariable<T> extends Variable<T> {
	
	Class<T> c;
	
	public EventValueVariable(final Class<T> c) {
		this.c = c;
	}
	
	@SuppressWarnings("unchecked")
	@Override
	protected final T[] getAll(final Event e) {
		final T[] t = (T[]) Array.newInstance(c, 1);
		t[0] = Skript.getEventValue(e, c);
		return t;
	}
	
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) {}
	
	@Override
	public Class<T> getReturnType() {
		return c;
	}
	
	@Override
	public String getDebugMessage(final Event e) {
		if (e == null)
			return "EventValueVariable(class=" + c.getName() + ")";
		return Skript.toString(Skript.getEventValue(e, c));
	}
	
}
