/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.variables.base;

import org.bukkit.block.Block;
import org.bukkit.event.Event;

import ch.njol.skript.api.Changer.ChangeMode;
import ch.njol.skript.api.Variable;
import ch.njol.skript.data.DefaultChangers;

/**
 * @author Peter Gttinger
 * 
 */
public abstract class BlockVariable extends Variable<Block> {
	
	@Override
	public Class<?> acceptChange(final ChangeMode mode) {
		return DefaultChangers.blockChanger.acceptChange(mode);
	}
	
	@Override
	public void change(final Event e, final Object[] delta, final ChangeMode mode) {
		DefaultChangers.blockChanger.change(get(e), delta, mode);
	}
	
	@Override
	public Class<? extends Block> getReturnType() {
		return Block.class;
	}
}
