/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.variables;

import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.World;
import org.bukkit.event.Event;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Changer.ChangeMode;
import ch.njol.skript.api.InitException;
import ch.njol.skript.api.ParseException;
import ch.njol.skript.api.Variable;
import ch.njol.skript.util.WeatherType;

/**
 * @author Peter Gttinger
 * 
 */
public class VarWeather extends Variable<WeatherType> {
	
	static {
		Skript.addVariable(VarWeather.class, WeatherType.class, "weather( in (world )?%world%)?");
	}
	
	private Variable<World> worlds;
	
	@SuppressWarnings("unchecked")
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) throws InitException, ParseException {
		worlds = (Variable<World>) vars.get(0);
	}
	
	@Override
	public String getDebugMessage(final Event e) {
		return "weather in " + worlds.getDebugMessage(e);
	}
	
	@Override
	protected WeatherType[] getAll(final Event e) {
		final World[] ws = worlds.get(e);
		final WeatherType[] r = new WeatherType[ws.length];
		for (int i = 0; i < ws.length; i++) {
			r[i] = WeatherType.fromWorld(ws[i]);
		}
		return r;
	}
	
	@Override
	public Class<?> acceptChange(final ChangeMode mode) {
		if (mode == ChangeMode.CLEAR || mode == ChangeMode.SET)
			return WeatherType.class;
		return null;
	}
	
	@SuppressWarnings("incomplete-switch")
	@Override
	public void change(final Event e, final Object[] delta, final ChangeMode mode) {
		switch (mode) {
			case CLEAR:
				for (final World w : worlds.get(e)) {
					w.setStorm(false);
					w.setThundering(false);
				}
			break;
			case SET:
				for (final World w : worlds.get(e)) {
					((WeatherType) delta[0]).setWeather(w);
				}
			break;
		}
	}
	
	@Override
	public Class<? extends WeatherType> getReturnType() {
		return WeatherType.class;
	}
	
}
