/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.variables;

import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.event.Event;

import ch.njol.skript.Skript;
import ch.njol.skript.api.InitException;
import ch.njol.skript.api.ParseException;
import ch.njol.skript.api.Variable;
import ch.njol.skript.util.VariableString;

/**
 * @author Peter Gttinger
 * 
 */
public class VarVariableString extends Variable<String> {
	
	static {
		Skript.addVariable(VarVariableString.class, String.class, "\"[^\"]+\"|'[^']+'");
	}
	
	private VariableString string;
	
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) throws InitException, ParseException {
		string = new VariableString(matcher.group());
	}
	
	@Override
	public String getDebugMessage(final Event e) {
		return string.getDebugMessage(e);
	}
	
	@Override
	protected String[] getAll(final Event e) {
		return new String[] {string.get(e)};
	}
	
	@Override
	public Class<? extends String> getReturnType() {
		return String.class;
	}
	
}
