/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.variables;

import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Changer.ChangeMode;
import ch.njol.skript.api.Variable;
import ch.njol.skript.util.ItemType;

/**
 * 
 * @author Peter Gttinger
 * 
 */
public class VarTool extends Variable<ItemStack> {
	
	static {
		Skript.addVariable(VarTool.class, ItemStack.class, "tool( of %player%)?");
	}
	
	private Variable<Player> players;
	
	@SuppressWarnings("unchecked")
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) {
		players = (Variable<Player>) vars.get(0);
	}
	
	@Override
	protected ItemStack[] getAll(final Event e) {
		final Player[] ps = players.get(e);
		final ItemStack[] r = new ItemStack[ps.length];
		for (int i = 0; i < ps.length; i++)
			r[i] = ps[i].getItemInHand();
		return r;
	}
	
	@Override
	public Class<?> acceptChange(final ChangeMode mode) {
		return ItemType.class;
	}
	
	@SuppressWarnings("incomplete-switch")
	@Override
	public void change(final Event e, final Object[] delta, final ChangeMode mode) {
		if (mode == ChangeMode.CLEAR) {
			for (final Player p : players.get(e))
				p.setItemInHand(null);
			return;
		}
		switch (mode) {
			case SET:
				for (final Player p : players.get(e)) {
					p.setItemInHand(((ItemType) delta[0]).getRandom());
				}
				return;
			case ADD:
				for (final Player p : players.get(e)) {
					final ItemStack is = p.getItemInHand();
					for (final ItemType it : (ItemType[]) delta)
						it.addTo(is);
					p.setItemInHand(is);
				}
				return;
			case REMOVE:
				for (final Player p : players.get(e)) {
					final ItemStack is = p.getItemInHand();
					for (final ItemType it : (ItemType[]) delta)
						it.removeFrom(is);
					p.setItemInHand(is);
				}
				return;
		}
	}
	
	@Override
	public Class<ItemStack> getReturnType() {
		return ItemStack.class;
	}
	
	@Override
	public String getDebugMessage(final Event e) {
		if (e == null)
			return "tool of " + players.getDebugMessage(e);
		return Skript.toString(getAll(e)[0]);
	}
	
}
