/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.variables;

import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.World;
import org.bukkit.event.Event;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Changer.ChangeMode;
import ch.njol.skript.api.Variable;
import ch.njol.skript.util.Time;
import ch.njol.skript.util.Timespan;

/**
 * 
 * @author Peter Gttinger
 * 
 */
public class VarTime extends Variable<Time> {
	
	static {
		Skript.addVariable(VarTime.class, Time.class, "time( (in|of) %world%)?");
	}
	
	private Variable<World> worlds = null;
	
	@SuppressWarnings("unchecked")
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) {
		worlds = (Variable<World>) vars.get(0);
	}
	
	@Override
	protected Time[] getAll(final Event e) {
		final World[] ws = worlds.get(e);
		final Time[] times = new Time[ws.length];
		for (int i = 0; i < ws.length; i++) {
			times[i] = new Time((int) ws[i].getTime());
		}
		return times;
	}
	
	@Override
	public Class<?> acceptChange(final ChangeMode mode) {
		switch (mode) {
			case ADD:
			case REMOVE:
				return Timespan.class;
			case SET:
				return Time.class;
			default:
				return null;
		}
	}
	
	@SuppressWarnings("incomplete-switch")
	@Override
	public void change(final Event e, final Object[] delta, final ChangeMode mode) {
		switch (mode) {
			case SET:
				for (final World w : worlds.get(e))
					w.setTime(((Time) delta[0]).getTicks());
			break;
			case ADD:
				for (final World w : worlds.get(e))
					w.setTime((long) (w.getTime() + ((Timespan) delta[0]).getTicks()));
			break;
			case REMOVE:
				for (final World w : worlds.get(e))
					w.setTime((long) (w.getTime() + ((Timespan) delta[0]).getTicks()));
			break;
		}
	}
	
	@Override
	public Class<Time> getReturnType() {
		return Time.class;
	}
	
	@Override
	public String getDebugMessage(final Event e) {
		if (e == null)
			return "time in " + worlds.getDebugMessage(e);
		return Skript.toString(getAll(e));
	}
	
}
