/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.variables;

import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.event.Event;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Variable;

/**
 * @author Peter Gttinger
 * 
 */
public class VarRandom extends Variable<Double> {
	
	static {
		Skript.addVariable(VarRandom.class, Double.class, "random number between %double% and %double%");
	}
	
	Variable<Double> lower, upper;
	
	@SuppressWarnings("unchecked")
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) {
		lower = (Variable<Double>) vars.get(0);
		upper = (Variable<Double>) vars.get(1);
	}
	
	@Override
	protected Double[] getAll(final Event e) {
		final double l = lower.get(e)[0];
		final double u = upper.get(e)[0];
		
		return new Double[] {l + Math.random() * (u - l)};
	}
	
	@Override
	public Class<Double> getReturnType() {
		return Double.class;
	}
	
	@Override
	public String getDebugMessage(final Event e) {
		return "random(" + lower + "," + upper + ")";
	}
	
}
