/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.variables;

import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.Inventory;

import ch.njol.skript.Skript;
import ch.njol.skript.api.InitException;
import ch.njol.skript.api.Variable;
import ch.njol.skript.api.Changer.ChangeMode;
import ch.njol.skript.data.DefaultChangers;
import ch.njol.skript.util.ItemType;

/**
 * @author Peter Gttinger
 * 
 */
public class VarPlayer extends Variable<Player> {
	
	static {
		Skript.addVariable(VarPlayer.class, Player.class, "player", "\"(\\S+)\"");
	}
	
	private OfflinePlayer player;
	
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) throws InitException {
		if (matchedPattern == 1) {
			player = Bukkit.getOfflinePlayer(matcher.group(1));
			if (!player.hasPlayedBefore())
				throw new InitException();
		}
	}
	
	@Override
	protected Player[] getAll(final Event e) {
		if (player == null)
			return new Player[] {Skript.getEventValue(e, Player.class)};
		return new Player[] {player.getPlayer()};
	}
	
	@Override
	public Class<Player> getReturnType() {
		return Player.class;
	}
	
	@Override
	public String getDebugMessage(final Event e) {
		if (e == null)
			return player == null ? "player" : '"' + player.getName() + '"';
		return Skript.toString(getAll(e)[0]);
	}
	
	@Override
	public Class<?> acceptChange(ChangeMode mode) {
		return ItemType.class;
	}
	
	@Override
	public void change(Event e, Object[] delta, ChangeMode mode) {
		Player[] players = get(e);
		Inventory[] invis = new Inventory[players.length];
		for (int i = 0; i < players.length; i++)
			invis[i] = players[i] == null ? null : players[i].getInventory();
		DefaultChangers.inventoryChanger.change(invis, delta, mode);
	}
	
}
