/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.variables;

import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.event.Event;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Changer.ChangeMode;
import ch.njol.skript.api.InitException;
import ch.njol.skript.api.ParseException;
import ch.njol.skript.api.Variable;
import ch.njol.skript.data.DefaultChangers;
import ch.njol.skript.util.Offset;

/**
 * @author Peter Gttinger
 * 
 */
public class VarOffset extends Variable<Object> {
	
	static {
		Skript.addVariable(VarOffset.class, Object.class, "blocks? %offset%( (of )?%block%)?", "%offset% (of )?%location%");
	}
	
	private Variable<Offset> offsets;
	private Variable<Block> blocks;
	private Variable<Location> locations;
	
	@SuppressWarnings("unchecked")
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) throws InitException, ParseException {
		offsets = (Variable<Offset>) vars.get(0);
		if (matchedPattern == 0)
			blocks = (Variable<Block>) vars.get(1);
		else
			locations = (Variable<Location>) vars.get(1);
	}
	
	@Override
	public String getDebugMessage(final Event e) {
		return (blocks == null ? "" : "block ") + offsets.getDebugMessage(e) + " of " + blocks.getDebugMessage(e);
	}
	
	@Override
	protected Object[] getAll(final Event e) {
		if (blocks != null) {
			final Block[] orig = blocks.get(e);
			final Block[] off = new Block[orig.length];
			final Offset offset = Offset.combine(offsets.get(e));
			for (int i = 0; i < orig.length; i++) {
				off[i] = offset.setOff(orig[i]);
			}
			return off;
		} else {
			final Location[] orig = locations.get(e);
			final Location[] off = new Location[orig.length];
			final Offset offset = Offset.combine(offsets.get(e));
			for (int i = 0; i < orig.length; i++) {
				off[i] = offset.setOff(orig[i]);
			}
			return off;
		}
	}
	
	@Override
	public Class<?> getReturnType() {
		if (blocks == null)
			return Location.class;
		return Block.class;
	}
	
	@Override
	public Class<?> acceptChange(final ChangeMode mode) {
		if (blocks == null)
			return null;
		return DefaultChangers.blockChanger.acceptChange(mode);
	}
	
	@Override
	public void change(final Event e, final Object[] delta, final ChangeMode mode) {
		DefaultChangers.blockChanger.change((Block[]) get(e), delta, mode);
	}
	
}
