/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.variables;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.bukkit.event.Event;

import ch.njol.skript.Skript;
import ch.njol.skript.TriggerFileLoader;
import ch.njol.skript.api.LoopVar;
import ch.njol.skript.api.ParseException;
import ch.njol.skript.api.Variable;
import ch.njol.skript.variables.base.VarVariable;
import ch.njol.util.Pair;

/**
 * used to access a loop's current value.
 * 
 * @author Peter Gttinger
 * 
 */
public class VarLoopValue extends VarVariable {
	
	static {
		Skript.addVariable(VarLoopValue.class, Object.class, "loop-(\\S+)");
	}
	
	private String name;
	
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) throws ParseException {
		name = matcher.group();
		String s = matcher.group(1);
		int i = 1;
		final Matcher m = Pattern.compile("^(.+)-(\\d+)$").matcher(matcher.group(1));
		if (m.matches()) {
			s = m.group(1);
			i = Integer.parseInt(m.group(2));
		}
		for (final Pair<String, LoopVar<?>> p : TriggerFileLoader.currentLoops) {
			if (p.first.equalsIgnoreCase(s)) {
				if (i > 1) {
					i--;
					continue;
				}
				var = p.second;
				return;
			}
		}
		throw new ParseException("'" + matcher.group() + "' is not a loopable value");
	}

	@Override
	public String getDebugMessage(final Event e) {
		if (e == null)
			return name;
		return var.getDebugMessage(e);
	}
	
}
