/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.variables;

import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Changer.ChangeMode;
import ch.njol.skript.api.InitException;
import ch.njol.skript.api.ParseException;
import ch.njol.skript.api.Variable;

/**
 * @author Peter Gttinger
 * 
 */
public class VarHealth extends Variable<Integer> {
	
	static {
		Skript.addVariable(VarHealth.class, Integer.class, "health( of %livingentity%)?");
	}
	
	private Variable<LivingEntity> entities;
	
	@SuppressWarnings("unchecked")
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) throws InitException, ParseException {
		entities = (Variable<LivingEntity>) vars.get(0);
	}
	
	@Override
	public String getDebugMessage(final Event e) {
		return "health of " + entities.getDebugMessage(e);
	}
	
	@Override
	protected Integer[] getAll(final Event e) {
		final LivingEntity[] es = entities.get(e);
		final Integer[] is = new Integer[es.length];
		for (int i = 0; i < es.length; i++)
			is[i] = Integer.valueOf(es[i].getHealth());
		return is;
	}
	
	@Override
	public Class<?> acceptChange(final ChangeMode mode) {
		return Integer.class;
	}
	
	@Override
	public void change(final Event e, final Object[] delta, final ChangeMode mode) {
		int s = 0;
		if (mode != ChangeMode.CLEAR)
			s = (Integer) delta[0];
		switch (mode) {
			case SET:
				for (final LivingEntity entity : entities.get(e))
					entity.setHealth(s);
				return;
			case ADD:
				for (final LivingEntity entity : entities.get(e))
					entity.setHealth(entity.getHealth() + s);
				return;
			case REMOVE:
				for (final LivingEntity entity : entities.get(e))
					entity.setHealth(entity.getHealth() - s);
				return;
			case CLEAR:
				for (final LivingEntity entity : entities.get(e))
					entity.setHealth(0);
		}
	}
	
	@Override
	public Class<? extends Integer> getReturnType() {
		return Integer.class;
	}
	
}
