/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.variables;

import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Furnace;
import org.bukkit.event.Event;
import org.bukkit.inventory.Slot;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Changer.ChangeMode;
import ch.njol.skript.api.Variable;
import ch.njol.skript.data.DefaultChangers;
import ch.njol.skript.util.SkriptSlot;

/**
 * @author Peter Gttinger
 * 
 */
public class VarFurnaceSlot extends Variable<Slot> {
	
	// Slot IDs:
	// ore: 0, fuel: 1, result: 2
	
	static {
		Skript.addVariable(VarFurnaceSlot.class, Slot.class, "ore( slot)?( of %block%)?",
				"fuel( slot)?( of %block%)?",
				"result( slot)?( of %block%)?");
	}
	
	private Variable<Block> blocks;
	private int slot;
	
	@SuppressWarnings("unchecked")
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) {
		blocks = (Variable<Block>) vars.get(0);
		slot = matchedPattern;
	}
	
	@Override
	protected Slot[] getAll(final Event e) {
		final Block[] bs = blocks.get(e);
		if (bs == null)
			return null;
		final Slot[] iss = new Slot[bs.length];
		for (int i = 0; i < bs.length; i++) {
			if (bs[i].getType() != Material.FURNACE)
				continue;
			iss[i] = new SkriptSlot(((Furnace) bs[i].getState()).getInventory(), slot);
		}
		return iss;
	}
	
	@Override
	public Class<? extends Slot> getReturnType() {
		return Slot.class;
	}
	
	@Override
	public String getDebugMessage(final Event e) {
		if (e == null)
			return "FurnaceSlot(slot#=" + slot + ")";
		return Skript.toString(getAll(e)[0]);
	}
	
	@Override
	public Class<?> acceptChange(final ChangeMode mode) {
		return DefaultChangers.slotChanger.acceptChange(mode);
	}
	
	@Override
	public void change(final Event e, final Object[] delta, final ChangeMode mode) {
		DefaultChangers.slotChanger.change(get(e), delta, mode);
	}
	
}
