/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.variables;

import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.event.Event;

import ch.njol.skript.Skript;
import ch.njol.skript.api.ParseException;
import ch.njol.skript.api.Variable;
import ch.njol.skript.variables.base.VarVariable;

/**
 * @author Peter Gttinger
 * 
 *         provided for convenience: one can write event-world to distinguish between the world named 'world', the event's world, and the loop's world for example.
 * 
 */
public class VarEventVariable extends VarVariable {
	
	static {
		Skript.addVariable(VarEventVariable.class, Object.class, "event-(\\S+)");
	}

	@Override
	public String getDebugMessage(final Event e) {
		return var.getDebugMessage(e);
	}
	
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) throws ParseException {
		var = Variable.parseNoLiteral(matcher.group(1), Skript.getVariables().iterator());
		if (var == null)
			throw new ParseException("'" + matcher.group() + "' is invalid");
	}
	
}
