/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.variables;

import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Changer.ChangeMode;
import ch.njol.skript.api.Variable;

/**
 * @author Peter Gttinger
 * 
 */
public class VarEventCancelled extends Variable<Boolean> {
	
	static {
		Skript.addVariable(VarEventCancelled.class, Boolean.class, "event cancelled");
	}
	
	@Override
	protected Boolean[] getAll(final Event e) {
		if (!(e instanceof Cancellable))
			return null;
		return new Boolean[] {((Cancellable) e).isCancelled()};
	}
	
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) {}
	
	@Override
	public Class<? extends Boolean> getReturnType() {
		return Boolean.class;
	}
	
	@Override
	public String getDebugMessage(final Event e) {
		return "event cancelled";
	}
	
	@Override
	public Class<?> acceptChange(final ChangeMode mode) {
		switch (mode) {
			case CLEAR:
			case SET:
				return Boolean.class;
			default:
				return null;
		}
	}
	
	@SuppressWarnings("incomplete-switch")
	@Override
	public void change(final Event e, final Object[] delta, final ChangeMode mode) {
		if (!(e instanceof Cancellable))
			return;
		switch (mode) {
			case CLEAR:
				((Cancellable) e).setCancelled(false);
			break;
			case SET:
				((Cancellable) e).setCancelled((Boolean) delta[0]);
		}
	}
	
}
