/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.variables;

import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Changer.ChangeMode;
import ch.njol.skript.api.Variable;
import ch.njol.skript.util.ItemType;

/**
 * @author Peter Gttinger
 * 
 */
public class VarDrops extends Variable<ItemStack> {
	
	static {
		Skript.addVariable(VarDrops.class, ItemStack.class, "drops");
	}
	
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) {}
	
	@Override
	protected ItemStack[] getAll(final Event e) {
		if (!(e instanceof EntityDeathEvent))
			return null;
		return ((EntityDeathEvent) e).getDrops().toArray(new ItemStack[0]);
	}
	
	@Override
	public Class<?> acceptChange(final ChangeMode mode) {
		return ItemType.class;
	}
	
	@Override
	public void change(final Event e, final Object[] delta, final ChangeMode mode) {
		if (!(e instanceof EntityDeathEvent))
			return;
		final List<ItemStack> drops = ((EntityDeathEvent) e).getDrops();
		switch (mode) {
			case SET:
				drops.clear();
				//$FALL-THROUGH$
			case ADD:
				for (final ItemType i : (ItemType[]) delta)
					drops.add(i.getRandom());
			break;
			case REMOVE:
				for (final ItemType i : (ItemType[]) delta)
					i.removeFrom(drops);
			break;
			case CLEAR:
				drops.clear();
			break;
		}
	}
	
	@Override
	public Class<? extends ItemStack> getReturnType() {
		return ItemStack.class;
	}
	
	@Override
	public String getDebugMessage(final Event e) {
		if (e == null)
			return "drops";
		return Skript.toString(getAll(e));
	}
	
}
