/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.variables;

import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.event.Event;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Variable;
import ch.njol.skript.util.Utils;

/**
 * 
 * @author Peter Gttinger
 * 
 */
public class VarAttacker extends Variable<Object> {
	
	static {
		Skript.addVariable(VarAttacker.class, Object.class, "attacker|damager");
	}
	
	@Override
	protected Object[] getAll(final Event e) {
		return new Object[] {Utils.getAttacker(e)};
	}
	
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) {}
	
	@Override
	public Class<? extends Object> getReturnType() {
		return Object.class;
	}
	
	@Override
	public String getDebugMessage(final Event e) {
		if (e == null)
			return "attacker";
		return Skript.toString(getAll(e)[0]);
	}
	
}
