/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.variables;

import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageEvent;

import ch.njol.skript.Skript;
import ch.njol.skript.api.Variable;
import ch.njol.skript.util.EntityType;
import ch.njol.util.Checker;

/**
 * @author Peter Gttinger
 * 
 */
public class VarAttacked extends Variable<LivingEntity> {
	
	static {
		Skript.addVariable(VarAttacked.class, LivingEntity.class, "(attacked|damaged|victim)( %entitytype%)?");
	}
	
	Variable<EntityType> types;
	
	@SuppressWarnings("unchecked")
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) {
		types = (Variable<EntityType>) vars.get(0);
	}
	
	@Override
	protected LivingEntity[] getAll(final Event e) {
		if (e instanceof EntityDamageEvent) {
			final Entity entity = ((EntityDamageEvent) e).getEntity();
			if (!(entity instanceof LivingEntity))// srsly wtf Bukkit? you can change return types of overriding functions!
				throw new RuntimeException();
			if (types.check(e, new Checker<EntityType>() {
				@Override
				public boolean check(final EntityType t) {
					return t.isInstance(entity);
				}
			}, false, false)) {
				return new LivingEntity[] {(LivingEntity) entity};
			}
		}
		return null;
	}
	
	@Override
	public Class<? extends LivingEntity> getReturnType() {
		return LivingEntity.class;
	}
	
	@Override
	public String getDebugMessage(final Event e) {
		if (e == null)
			return "attacked(type=" + types.getDebugMessage(e) + ")";
		return Skript.toString(getAll(e)[0], true);
	}
	
}
