/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.util;

import java.util.HashMap;

import org.bukkit.World;

/**
 * 
 * @author Peter Gttinger
 * 
 */
public enum WeatherType {
	
	clear("clear", "sun", "sunny"), rain("rain", "rainy", "raining"), thunder("thunder", "thundering");
	
	private final String[] names;
	
	private final static HashMap<String, WeatherType> byName = new HashMap<String, WeatherType>();
	
	private WeatherType(final String... names) {
		this.names = names;
	}
	
	static {
		for (final WeatherType t : values()) {
			for (final String name : t.names) {
				byName.put(name, t);
			}
		}
	}
	
	public static final WeatherType parse(final String s) {
		return byName.get(s);
	}
	
	public static WeatherType fromWorld(final World world) {
		if (world.isThundering())
			return thunder;
		if (world.hasStorm())
			return rain;
		return clear;
	}
	
	@Override
	public String toString() {
		switch (this) {
			case clear:
				return "clear";
			case rain:
				return "rain";
			case thunder:
				return "thunder";
		}
		return null;
	}
	
	public String adjective() {
		switch (this) {
			case clear:
				return "sunny";
			case rain:
				return "raining";
			case thunder:
				return "thundering";
		}
		return null;
	}
	
	public boolean isWeather(final World w) {
		return isWeather(w.hasStorm(), w.isThundering());
	}
	
	public boolean isWeather(final boolean rain, final boolean thunder) {
		switch (this) {
			case clear:
				return !thunder && !rain;
			case rain:
				return !thunder && rain;
			case thunder:
				return thunder && rain;
			default:
				throw new RuntimeException();
		}
	}
	
	public void setWeather(final World w) {
		w.setStorm(this == rain || this == thunder);
		w.setThundering(this == thunder);
	}
	
}
