/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.util;

/**
 * 
 * @author Peter Gttinger
 * 
 */
public class Timeperiod {
	int start = 0, end = 24000;
	
	public Timeperiod(final int start, final int end) {
		this.start = start;
		this.end = end;
	}
	
	public Timeperiod(final int time) {
		start = end = time;
	}
	
	public boolean contains(final int time) {
		return (time >= start && time <= end) || end < start && (time <= end || time >= start);
	}
	
	/**
	 * @return "start-end" or "start" if start == end
	 */
	@Override
	public String toString() {
		return "" + Time.toString(start) + (start == end ? "" : "-" + Time.toString(end));
	}
	
	@Override
	public int hashCode() {
		return start + end << 16;
	}
	
	@Override
	public boolean equals(final Object obj) {
		if (obj == this)
			return true;
		if (!(obj instanceof Timeperiod))
			return false;
		final Timeperiod other = (Timeperiod) obj;
		return (end == other.end && start == other.start);
	}
	
}
