/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.util;

import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Slot;

/**
 * @author Peter Gttinger
 * 
 */
public class SkriptSlot implements Slot {
	
	private final Inventory invi;
	private final int index;
	
	public SkriptSlot(final Inventory invi, final int index) {
		this.invi = invi;
		this.index = index;
	}
	
	@Override
	public Inventory getInventory() {
		return invi;
	}
	
	@Override
	public int getIndex() {
		return index;
	}
	
	@Override
	public ItemStack getItem() {
		return invi.getItem(index);
	}
	
	public void setItem(final ItemStack item) {
		invi.setItem(index, item);
	}
	
}
