/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.util;

import org.bukkit.entity.Entity;

/**
 * 
 * @author Peter Gttinger
 * 
 */
public class EntityType {
	public Class<? extends Entity> c;
	// TODO: powered creepers, angry wolves, etc.
	public int amount = 1;
	
	public EntityType(final Class<? extends Entity> c, final int amount) {
		this.c = c;
		this.amount = amount;
	}
	
	public boolean isInstance(final Entity entity) {
		return c.isInstance(entity);
	}
	
	@Override
	public String toString() {
		return amount + " " + c.getSimpleName();
	}
	
	@Override
	public int hashCode() {
		return amount * c.hashCode();
	}
	
	@Override
	public boolean equals(final Object obj) {
		if (obj == this)
			return true;
		if (!(obj instanceof EntityType))
			return false;
		final EntityType other = (EntityType) obj;
		return (amount == other.amount && c == other.c);
	}
	
}
