/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.util;

import java.util.Iterator;

import org.bukkit.Location;
import org.bukkit.block.Block;

public class BlockSphereIterator implements Iterator<Block> {
	
	final Location center;
	final float radius;
	private int x, y, z;
	private Block current, next;
	
	public BlockSphereIterator(final Location center, final float radius) {
		this.center = center;
		this.radius = radius;
		x = (int) Math.round(center.getX() - radius);
		y = (int) Math.round(center.getY() - radius);
		z = (int) Math.round(center.getZ() - radius);
	}
	
	private final double distSq() {
		return (center.getX() - x) * (center.getX() - x) + (center.getY() - y) * (center.getY() - y) + (center.getZ() - z) * (center.getZ() - z);
	}
	
	@Override
	public boolean hasNext() {
		if (next == null)
			next();
		return next != null;
	}
	
	@Override
	public Block next() {
		next = null;
		for (; next != null && x < Math.round(center.getX() + radius); x++) {
			for (; next != null && y < Math.round(center.getY() + radius); y++) {
				for (; next != null && z < Math.round(center.getZ() + radius); z++) {
					if (distSq() > radius * radius)
						continue;
					next = center.getWorld().getBlockAt(x, y, z);
				}
			}
		}
		if (next != null)
			current = next;
		return next;
	}
	
	@Override
	public void remove() {
		throw new UnsupportedOperationException();
	}
	
	public Block current() {
		return current;
	}
}
