/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.loops;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Matcher;

import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

import ch.njol.skript.Skript;
import ch.njol.skript.api.LoopVar;
import ch.njol.skript.api.Variable;
import ch.njol.skript.util.Utils;

/**
 * @author Peter Gttinger
 * 
 */
public class LoopVarPlayer extends LoopVar<Player> {
	
	static {
		Skript.addLoop(LoopVarPlayer.class, Player.class, "player", "players", "players in worlds? %world%");
	}
	
	private Variable<World> worlds = null;
	
	@SuppressWarnings("unchecked")
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) {
		if (vars.size() > 0)
			worlds = (Variable<World>) vars.get(0);
	}
	
	@Override
	protected Iterator<Player> iterator(final Event e) {
		if (worlds == null)
			return Arrays.asList(Bukkit.getOnlinePlayers()).iterator();
		return new Iterator<Player>() {
			
			private final ListIterator<Player> players = Arrays.asList(Bukkit.getOnlinePlayers()).listIterator();
			
			private final World[] ws = worlds.get(e);
			
			@Override
			public boolean hasNext() {
				while (players.hasNext()) {
					if (Utils.contains(ws, players.next().getWorld()) != -1) {
						players.previous();
						return true;
					}
				}
				return false;
			}
			
			@Override
			public Player next() {
				return players.next();
			}
			
			@Override
			public void remove() {}
			
		};
	}
	
	@Override
	public Class<? extends Player> getReturnType() {
		return Player.class;
	}
	
	@Override
	public String getDebugMessage(final Event e) {
		return "players in world " + worlds.getDebugMessage(e);
	}
	
}
