/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.loops;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;

import org.bukkit.Material;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

import ch.njol.skript.Skript;
import ch.njol.skript.api.LoopVar;
import ch.njol.skript.api.Variable;
import ch.njol.skript.util.ItemType;
import ch.njol.util.CheckedIterator;
import ch.njol.util.Checker;

/**
 * @author Peter Gttinger
 * 
 */
public class LoopVarItem extends LoopVar<ItemStack> {
	
	static {
		Skript.addLoop(LoopVarItem.class, ItemStack.class, "item", "item(s| ?types)", "items of types? %itemtype%");
		Skript.addLoop(LoopVarItem.class, ItemStack.class, "block", "block(s| ?types)", "blocks of types? %itemtype%");
	}
	
	private Variable<ItemType> types = null;
	private boolean blocks = false;
	
	@SuppressWarnings("unchecked")
	@Override
	public void init(final List<Variable<?>> vars, final int matchedPattern, final Matcher matcher) {
		if (vars.size() > 0)
			types = (Variable<ItemType>) vars.get(0);
		blocks = matcher.group().startsWith("block");
	}
	
	@Override
	protected Iterator<ItemStack> iterator(final Event e) {
		Iterator<ItemStack> iter;
		if (types == null) {
			iter = new Iterator<ItemStack>() {
				
				private final Iterator<Material> iter = Arrays.asList(Material.values()).iterator();
				
				@Override
				public boolean hasNext() {
					return iter.hasNext();
				}
				
				@Override
				public ItemStack next() {
					return new ItemStack(iter.next());
				}
				
				@Override
				public void remove() {}
				
			};
		} else {
			iter = new Iterator<ItemStack>() {
				
				private final Iterator<ItemType> iter = Arrays.asList(types.get(e)).iterator();
				Iterator<ItemStack> current;
				
				@Override
				public boolean hasNext() {
					return iter.hasNext() || current.hasNext();
				}
				
				@Override
				public ItemStack next() {
					if (current == null || !current.hasNext()) {
						current = iter.next().getAll();
					}
					return current.next();
				}
				
				@Override
				public void remove() {}
				
			};
		}
		
		if (!blocks)
			return iter;
		
		return new CheckedIterator<ItemStack>(iter, new Checker<ItemStack>() {
			@Override
			public boolean check(final ItemStack is) {
				return is.getTypeId() <= Skript.MAXBLOCKID;
			}
		});
	}
	
	@Override
	public Class<? extends ItemStack> getReturnType() {
		return ItemStack.class;
	}
	
	@Override
	public String getDebugMessage(final Event e) {
		return (blocks ? "blocks" : "items") + " of type " + types.getDebugMessage(e);
	}
	
}
