/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.events;

import java.util.regex.Matcher;

import org.bukkit.event.Event;
import org.bukkit.event.weather.ThunderChangeEvent;
import org.bukkit.event.weather.WeatherChangeEvent;

import ch.njol.skript.Skript;
import ch.njol.skript.api.SkriptEvent;
import ch.njol.skript.util.Utils;
import ch.njol.skript.util.WeatherType;

/**
 * @author Peter Gttinger
 * 
 */
@SuppressWarnings("unchecked")
public class EvtWeatherChange extends SkriptEvent {
	
	static {
		Skript.addEvent(EvtWeatherChange.class, Skript.array(WeatherChangeEvent.class, ThunderChangeEvent.class), "weather change( to %weathertype%)?");
	}
	
	private WeatherType[] types;
	
	@Override
	public void init(final Object[][] args, final int matchedPattern, final Matcher matcher) {
		types = (WeatherType[]) args[0];
	}
	
	@Override
	public boolean check(final Event e) {
		final boolean rain = e instanceof WeatherChangeEvent ? ((WeatherChangeEvent) e).toWeatherState() : ((ThunderChangeEvent) e).getWorld().hasStorm();
		final boolean thunder = e instanceof ThunderChangeEvent ? ((ThunderChangeEvent) e).toThunderState() : ((WeatherChangeEvent) e).getWorld().isThundering();
		for (final WeatherType t : types) {
			if (t.isWeather(rain, thunder))
				return true;
		}
		return false;
	}
	
	@Override
	public String getDebugMessage(final Event e) {
		return "weather change to " + Utils.join(types);
	}
	
}
