/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.events;

import java.util.regex.Matcher;

import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

import ch.njol.skript.Skript;
import ch.njol.skript.api.SkriptEvent;
import ch.njol.skript.util.EntityType;
import ch.njol.skript.util.ItemType;

/**
 * @author Peter Gttinger
 * 
 */
@SuppressWarnings("unchecked")
public class EvtRightclick extends SkriptEvent {
	
	static {
		Skript.addEvent(EvtRightclick.class, Skript.array(PlayerInteractEvent.class, PlayerInteractEntityEvent.class),
				"rightclick(ing)?( on %itemtype%)?( (with|unsing|holding) %itemtype%)?",
				"rightclick(ing)?( on %entitytype%)?( (with|unsing|holding) %itemtype%)?");
	}
	
	private ItemType[] blocks = null;
	private EntityType[] entities = null;
	private ItemType[] tools;
	
	@Override
	public void init(final Object[][] args, final int matchedPattern, final Matcher matcher) {
		if (args[0] instanceof ItemType[])
			blocks = (ItemType[]) args[0];
		else
			entities = (EntityType[]) args[0];
		tools = (ItemType[]) args[1];
	}
	
	@Override
	public boolean check(final Event e) {
		if (!(e instanceof PlayerInteractEntityEvent
				|| ((PlayerInteractEvent) e).getAction() == Action.RIGHT_CLICK_AIR
				|| ((PlayerInteractEvent) e).getAction() == Action.RIGHT_CLICK_BLOCK))
			return false;
		boolean ok = false;
		if (tools != null) {
			for (final ItemType tool : tools) {
				if (tool.isOfType(((PlayerEvent) e).getPlayer().getItemInHand())) {
					ok = true;
					break;
				}
			}
			if (!ok)
				return false;
		}
		if (blocks == null && entities == null)
			return true;
		if (e instanceof PlayerInteractEntityEvent && entities != null) {
			for (final EntityType entity : entities) {
				if (entity.isInstance(((PlayerInteractEntityEvent) e).getRightClicked())) {
					return true;
				}
			}
			return false;
		} else if (e instanceof PlayerInteractEvent && blocks != null) {
			final ItemStack air = new ItemStack(0, 1);
			for (final ItemType block : blocks) {
				if (((PlayerInteractEvent) e).getAction() == Action.RIGHT_CLICK_AIR) {
					if (block.isOfType(air)) {
						return true;
					}
				} else if (block.isOfType(((PlayerInteractEvent) e).getClickedBlock())) {
					return true;
				}
			}
			return false;
		}
		return false;
	}
	
	@Override
	public String getDebugMessage(final Event e) {
		return "rightclick on " + Skript.toString(blocks == null ? entities : blocks) + " holding " + Skript.toString(tools);
	}
	
}
