/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.events;

import java.util.regex.Matcher;

import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.event.Event;

import ch.njol.skript.Skript;
import ch.njol.skript.api.SkriptEvent;
import ch.njol.skript.util.ScheduledEvent;
import ch.njol.skript.util.Timespan;

public class EvtPeriodical extends SkriptEvent {
	
	static {
		Skript.addEvent(EvtPeriodical.class, ScheduledEvent.class, "every %timespan%( in( worlds?)? %world%)?");
	}
	
	@Override
	public void init(final Object[][] args, final int matchedPattern, final Matcher matcher) {
		final int t = Math.round(((Timespan) args[0][0]).getTicks());
		final World[] worlds = (World[]) args[1];
		final EvtPeriodical evt = this;
		if (worlds == null) {
			Bukkit.getScheduler().scheduleSyncRepeatingTask(Skript.getPlugin(), new Runnable() {
				@Override
				public void run() {
					Bukkit.getPluginManager().callEvent(new ScheduledEvent(null, evt));
				}
			}, t, t);
		} else {
			for (final World w : worlds) {
				Bukkit.getScheduler().scheduleSyncRepeatingTask(Skript.getPlugin(), new Runnable() {
					@Override
					public void run() {
						Bukkit.getPluginManager().callEvent(new ScheduledEvent(w, evt));
					}
				}, t - (w.getFullTime() % t), t);
			}
		}
	}
	
	@Override
	public boolean check(final Event e) {
		return ((ScheduledEvent) e).getSkriptEvent() == this;
	}
	
	@Override
	public String getDebugMessage(final Event e) {
		return "periodical";
	}
	
}
