/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.events;

import java.util.regex.Matcher;

import org.bukkit.Material;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityChangeBlockEvent;

import ch.njol.skript.Skript;
import ch.njol.skript.api.SkriptEvent;

/**
 * @author Peter Gttinger
 * 
 */
public class EvtEntityBlockChange extends SkriptEvent {
	
	static {
		Skript.addEvent(EvtEntityBlockChange.class, EntityChangeBlockEvent.class, "enderman pickup", "enderman place");
	}
	
	private boolean pickup;
	
	@Override
	public void init(final Object[][] args, final int matchedPattern, final Matcher matcher) {
		pickup = matchedPattern == 0;
	}
	
	@Override
	public boolean check(final Event e) {
		return pickup ^ ((EntityChangeBlockEvent) e).getTo() != Material.AIR;
	}
	
	@Override
	public String getDebugMessage(final Event e) {
		return "enderman change";
	}
	
}
