/*
 * This work is licensed under the Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Switzerland License. To view a copy of this license, visit
 * http://creativecommons.org/licenses/by-nc-sa/2.5/ch/ or send a letter to Creative Commons, 444 Castro Street, Suite 900, Mountain View, California, 94041, USA.
 */

package ch.njol.skript.events;

import java.util.regex.Matcher;

import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityDeathEvent;

import ch.njol.skript.Skript;
import ch.njol.skript.api.SkriptEvent;
import ch.njol.skript.util.EntityType;

/**
 * @author Peter Gttinger
 * 
 */
public class EvtEntity extends SkriptEvent {
	
	static {
		Skript.addEvent(EvtEntity.class, EntityDeathEvent.class, "death( of %entitytype%)?");
		Skript.addEvent(EvtEntity.class, CreatureSpawnEvent.class, "spawn(ing)?( of %entitytype%)");
	}
	
	EntityType[] types;
	
	@Override
	public void init(final Object[][] args, final int matchedPattern, final Matcher matcher) {
		types = (EntityType[]) args[0];
	}
	
	@Override
	public boolean check(final Event e) {
		if (types == null)
			return true;
		final Entity en = Skript.getEventValue(e, Entity.class);
		for (final EntityType type : types) {
			if (type.isInstance(en))
				return true;
		}
		return false;
	}
	
	@Override
	public String getDebugMessage(final Event e) {
		return "death/spawn of " + Skript.toString(types);
	}
	
}
